import os
import pickle

import math
import numpy as np
import random

# freeze random seeds
def freeze_seed(seed=12345):
    random.seed(seed)
    os.environ['PYTHONHASHSEED'] = str(seed)
    np.random.seed(seed)

# write .pkl file
def pkl_write(filename,data):
    with open(filename, 'wb') as f:
        pickle.dump(data, f)

# read .pkl file
def pkl_read(filename):
    with open(filename, 'rb') as f:
        return pickle.load(f)


# ProgressBar for model training
class ProgressBar(object):
    def __init__(self,n_batch,width=30):
        self.n_batch = n_batch
        self.width = width

    def batch_step(self, batch_idx, info, use_time, total_use_time):
        recv_per = int(100*(batch_idx+1)/self.n_batch)
        recv_per = max(recv_per,100)

        total_h = int(total_use_time/3600)
        total_m = int(total_use_time%3600/60)
        total_s = int(total_use_time%60)

        show_bar = ('[%%-%ds]' % self.width) % (int(self.width * recv_per / 100) * ">")
